##############################################################################
# explodemovie.tcl -- explode curr hemi curr brain
##############################################################################
## interactive:
#    load subj surface from csurf
#    select "#/explodemovie.tcl" from "tcl:" dropdown
#    click GO, adj pop-up parms if needed, RUN SCRIPT
#    [default: save 1460 tiffs to $SUBJECTS_DIR/$subject/rgb/f%05d.tiff]
#    [for movie: 30 frames/sec]
## cmdline:
#    tksurfer martys09 rh smoothwm -tcl $CSURF_DIR/lib/tcl/explodemovie.tcl
### N.B.: caller must omit $userok or pass $userok=0

### hard defaults
if ![info exists userok] { set userok 0 }

### adjustable parms (interactive adj w/popup, or edit here for cmdline script)
if {!$userok} {  ;# don't blow away reset by controls
  set startsurf smoothwm ;# (smoothwm) other adj ripparms (N.B.:surfext traced)
  set explodeflag 1      ;# (1) turn on rip edge if too much stress
  set expandflag 1       ;# (1) turn on inflate to cause stress
  set mstrength 0.10     ;# (0.10) inflate force
  set momentumflag 1     ;# (1)
  set stressthresh 3.0   ;# (3.0) a little higher for slower rips
  set ws 1.9             ;# (1.9) vs. def=0.5, for slower rips
  set wn 0.5             ;# (0.5) shrink default
  set scalefact 1.05     ;# (1.05) less black for smoothwm
  set winsize 1000       ;# (1000)
  set blufact 1.5        ;# (1.5) -- 1.0 is neutral
  set cslope 5.0         ;# (5.0) more contrast than def=3.0
  set maincyc 500        ;# (700)
  set fadecyc 200        ;# (200)
  set pausecyc 60        ;# (60) frames at return to orig
  set savetiffsflag 1    ;# (1) save tiffs
}

#############################################################################
### for cmdline use
if {!$openglwindowflag} { open_window }

### popup controls
if [winfo viewable .] {  ;# popup
  if {!$userok} {
    set explodemoviectrls [controls "EXPLODE MOVIE LOOP\
            \nDim End, Cp2Rev, Pause\
            \n\$mstrength: inflate force\
            \n   \$ws: neighbor force\
            \n\$wn: normal force" {
      startsurf explodeflag expandflag momentumflag
      mstrength stressthresh ws wn
      scalefact winsize blufact cslope maincyc fadecyc pausecyc
      savetiffsflag
    } "RUN SCRIPT" "set userok 1; source [info script]" 12]
    bind $explodemoviectrls <ButtonRelease-3> { helpwin script_explodemovie }
    return
  }
} else {                 ;# batch scripts; re-read env to override defaults
  source $env(CSURF_DIR)/lib/tcl/readenv.tcl
}

### go
puts "explodemovie.tcl: #####################################"
puts "explodemovie.tcl: begin saving tiffs (startframe=f[format "%05d" 0])"
puts "explodemovie.tcl: #####################################"

### resize window
resize_window $winsize
raise_window
make_lateral_view
scale_brain $scalefact

### (re)read surface-to-explode
setfile insurf ~/surf/$hemi.$startsurf
read_binary_surface
clear_ripflags
redraw

### def lights
set deflight0 0.4   ;# (def:0.4) from eye
set deflight1 0.0   ;# (def:0.0) behind brain
set deflight2 0.8   ;# (def:0.8) upper right
set deflight3 0.2   ;# (def=0.2) left
set light0 $deflight0
set light1 $deflight1
set light2 $deflight2
set light3 $deflight3

### explode, maybe save frames
do_lighting_model
set tiffcnt 0
set steps 1
set totcyc [expr $maincyc + $fadecyc]
set rotfrac [expr 360.0/$totcyc.0]
set fadefrac [expr 1.0/$fadecyc.0]
set rgbs 0
for {set cyc 0} {$cyc < $totcyc} {incr cyc} {
  shrink $steps
  #rotate_brain_y $rotfrac
  redraw
  if {$savetiffsflag} {
    setfile rgb ~/rgb/f[format "%05d" $cyc].tiff
    save_rgb
  }
  if {$cyc >= $maincyc} {  ;# fade
    set light0 [expr $light0 - ($fadefrac * $deflight0)]
    set light1 [expr $light1 - ($fadefrac * $deflight1)]
    set light2 [expr $light2 - ($fadefrac * $deflight2)]
    set light3 [expr $light3 - ($fadefrac * $deflight3)]
    do_lighting_model
  }
  incr rgbs
  incr tiffcnt
}

### cp frames to make closed movie loop with pause at end (only if save)
if {$savetiffsflag} {
  # copy to reverse sequence (make loop)
  set subtr 1
  for {set i $rgbs} {$i < [expr 2*$totcyc] } {incr i} {
    setfile rgb ~/rgb/f[format "%05d" $i].tiff
    set targ $rgb
    setfile rgb ~/rgb/f[format "%05d" [expr $i - $subtr]].tiff
    set src $rgb
    puts "exec cp $src $targ"
    exec cp $src $targ
    incr subtr 2
    incr tiffcnt
  }
  # hold for $pausecnt frames before re-explode
  for {set j $i} {$j < [expr $i + $pausecyc] } {incr j} {
    setfile rgb ~/rgb/f[format "%05d" $j].tiff
    set targ $rgb
    puts "exec cp $src $targ"
    exec cp $src $targ
    incr tiffcnt
  }
  # done
  puts "explodemovie.tcl: ########################"
  puts "explodemovie.tcl: done saving $tiffcnt tiffs"
  puts "explodemovie.tcl: ########################"
} else {
  puts "explodemovie.tcl: ########################"
  puts "explodemovie.tcl: $tiffcnt frames (not saved)"
  puts "explodemovie.tcl: ########################"
}

