#! /usr/bin/tclsh
##############################################################################
# tksurfer script: fs-flat     [display fieldsign on patch]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### session dir autoset to $cwd/.. when cwd=scripts (standalone: set here)
#set isession /usr0/fspace/110329MS/image

### tcl-only defs (set for standalone tclscript, order: cmdline,here,readenv)
#set dir fs             ;# scandir, usu. subdir of "image/" (old: 004/image7)
#set rgbname fs         ;# name of rgbfiles
#set patchname occip.patch.flat   ;# appended to $hemi.
#set flatzrot 0         ;# patch rotate
#set flatscale 1.0      ;# patch scale

### parm defaults: can reset in csh script with setenv
#set overlayflag 1       ;# overlay data on gray brain
#set surfcolor 1         ;# draw the curvature under data
#set avgflag 1           ;# make half convex/concave
#set complexvalflag 0    ;# one-component data
#set autoscaleflag 1     ;# for fs,CMF
#set colscale 9          ;# 0=wheel,1=heat,2=BR,3=BGR,4=twocondGR,5=gray,9=fs
#set fthresh 0.3         ;# val/curv sigmoid zero (neg=>0)
#set fslope 5.0          ;# contast
#set fmid   0.6          ;# set linear region
#set offset 0.30         ;# default lighting offset
#set cvfact 1.30         ;# background light/dark curv gray contrast
#set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read default patch view if there (after env to use patchname)
source $env(CSURF_DIR)/lib/tcl/setdefpatchview.tcl

### default missing tcl-only for standalone
if ![info exists dir ]      { set dir fs }
if ![info exists rgbname]   { set rgbname $dir }
if ![info exists patchname] { set patchname occip.patch.flat }
if ![info exists flatzrot]  { set flatzrot 0 }
if ![info exists flatscale] { set flatscale 1.0 }
set complexvalflag 0     ;# force correct

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
read_binary_curv

### read 2D patch; calc,write fieldsign and mask
puts "tksurfer: [file tail $script]: read patch"
setfile patch ~/surf/$hemi.$patchname
read_binary_patch       ;# overwrites initial surface read in

### read fieldsign 
setfile fs */$dir/$hemi.fs
setfile fm */$dir/$hemi.fm
puts "tksurfer: [file tail $script]: read fieldsign"
read_fieldsign          ;# -1,0,1
puts "tksurfer: [file tail $script]: read fieldsign mask"
read_fsmask             ;# thresh, now depends on eccen *and* polar angle

### override flag reset from bad setenv colscale
if {$fieldsignflag} { set complexvalflag 0 }

### initial scale and position patch
puts "tksurfer: [file tail $script]: scale, position brain"
open_window
restore_zero_position   ;# undo initial centering
rotate_brain_x -90
do_lighting_model

### save requested rgbs (transforms done here)
puts "tksurfer: [file tail $script]: save rgb's"
source $env(CSURF_DIR)/lib/tcl/saveflat.tcl

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

