#! /usr/bin/tclsh
##############################################################################
# tksurfer script: movie360.tcl [rotate around various axes]
##############################################################################
### uses current surface pose (N.B.: caller should init $userok to 0)

### hard defaults
if ![info exists userok] { set userok 0 }
set entwidth 25
set dscale 1.01
set imsuff rgb

### adjustable parm defaults
if {!$userok} {  ;# don't blow away reset by controls on re-enter
  set mpgstem $subject-$surfext-$hemi
  set steps 180
  set reverse_rot 0
  set rottype:ry,rx,s,sx,sxs,ryx ry   ;# varname is also interface label...
  set adjscale 1.0
  set savetiffs 0
  set use_ffmpeg 0    ;# make .mp4 directly vs. .mpg (if ffmpeg on path)
}


### popup controls (N.B.: buttonname "RUN SCRIPT" req'd for purplekillcontrols)
if ![info exists movie360ctrls] { set movie360ctrls "" }
if [winfo viewable .] {
  if {!$userok} {
    if [winfo exists $movie360ctrls] { raise $movie360ctrls; return }
    set movie360ctrls [controls "ROTATE (r) and SCALE (s) MOVIES" {
      mpgstem
      steps
      reverse_rot
      rottype:ry,rx,s,sx,sxs,ryx
      adjscale
      savetiffs
      use_ffmpeg
    } "RUN SCRIPT" "set userok 1; source [info script]" $entwidth]
    bind $movie360ctrls <ButtonRelease-3> { helpwin script_movie360 }
    return
  }
} else {                 ;# batch scripts; re-read env to override defaults
  source $env(CSURF_DIR)/lib/tcl/readenv.tcl
}
set type ${rottype:ry,rx,s,sx,sxs,ryx}  ;# cp var easier on the eye

#TODO: toplevel adjscale widget (.controls.adjscale.e) not visible here
#if ![string match s* $type] {
#  .controls.adjscale.e config -state disabled
#}

### go into local mpg dir, maybe make it first
if ![file exists $isession/mpg] { exec mkdir $isession/mpg }
cd $isession/mpg

### various movies
set f 0
set dr [expr 360.0 / $steps.0]
if {$type == "ryx"} {set dr [expr $dr / sqrt(2.0)]}
if {$reverse_rot} {set dr [expr -$dr]}
set ds [expr $adjscale * $dscale]
if [info exists tiffoutflag] {
  if {$tiffoutflag} { set imsuff tiff }
}
if {$use_ffmpeg} {
  if ![foundbywhich ffmpeg] {confirmalert "ffmpeg not found on \$path"; return}
  set imsuff tiff
}

set drawnflag 0
for {set i 0} {$i < $steps} {incr i} {
  if {$type == "ry"} {
    if {$hemi == "rh"} { rotate_brain_y -$dr }
    if {$hemi == "lh"} { rotate_brain_y  $dr }
  } elseif {$type == "rx"} {
    rotate_brain_x -$dr
  } elseif {$type == "s"} {
    scale_brain $ds
  } elseif {$type == "sx"} {
    rotate_brain_x -$dr
    scale_brain $ds
  } elseif {$type == "sxs"} {
    rotate_brain_x -$dr
    if {$i < [expr $steps/2]} {
      scale_brain $ds
    } else {
      scale_brain [expr 1.0/$ds]
    }
  } elseif {$type == "ryx"} {
    if {$hemi == "rh"} { rotate_brain_y -$dr }
    if {$hemi == "lh"} { rotate_brain_y  $dr }  ;# bucky3b
    rotate_brain_x -$dr
  } else { confirmalert "bad movie type: $type"; return }
  if {!$drawnflag} { redraw; set drawnflag 1 } else { redraw_cached }
  raise_window
  set rgb f[format "%05d" $f].$imsuff
  save_rgb
  incr f
  update   ;# refresh surfer tools
  if {$purplekillcontrols} {
    set purplekillcontrols 0
    confirmalert "Script interrupted:\n\n$script"
    return
  }
}

### make quality=1 mpg, or mp4
after 200 { set userok $userok }
confirmalert "making mpeg -- takes a few sec"
if {$imsuff == "rgb"} {
  puts [eval exec rgb2mpg -q 1 f*.$imsuff $mpgstem.mpg]
}
if {$imsuff == "tiff" && !$use_ffmpeg } {
  puts [eval exec tiff2mpg -q 1 f*.$imsuff $mpgstem.mpg]
}
if {$imsuff == "tiff" && $use_ffmpeg } {
  puts [eval exec ffmpeg -v 0 -f image2 -r 20 -i f%5d.$imsuff -vcodec libx264 -pix_fmt yuv420p $mpgstem.mp4]
}

### test show movie if mpg
if {!$use_ffmpeg} {
  puts \
    [eval exec mpeg_play -dither color -quiet -loop $mpgstem.mpg >& /dev/null &]
}

### cleanup
if {$savetiffs} {
  confirmalert "tiffs saved in [pwd]"
} else {
  foreach tmprgb [glob f?????.$imsuff] { exec rm $tmprgb }
}
set userok 0
#if [info exists movie360ctrls] { destroy $movie360ctrls }
return

