#! /usr/local/bin/tclsh7.4
############################################################################
# tkstrip tcl script:   tkstrip martys09 T1 -tcl stripskull.tcl
############################################################################
### wrap entire script to catch errors/crashes for log
catch {

############################################################################
## parms
set viewlevel      1   ;# 0=offline, 1=justview, 2=savemovie
set shrinksteps  200
set smoothsteps   10
set shrinkmode     1   ;# 1=brain
set fzero         45
set fmax         120
set dfrac          0.7
set istilt         1.0

### default in/out image, in/out tri surf
set localinsurf     0        ;# default=0: bem/lib icos's (else subject bemdir)
set insurfname    ic4.tri    ;# default: 4th order tessellation
set outsurfname   brain.tri  ;# always to subject's bemdir
set inimagedir      T1       ;# always from mri subdir
set outimagedir   brain      ;# always to mri subdir (also tmp)
############################################################################

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read in icosahedral tessellation (may be deformed if local)
if {$localinsurf} {
  setfile insurf ~/surf/$insurfname  ;# from subject's surfdir
} else {
  setfile insurf @/$insurfname       ;# init bem/lib icosahedrons
}
read_geometry

### read in images
setfile inim ~/mri/$inimagedir
read_images

### init icos to requested fraction (dfrac) of brain bounding box
init_surf_to_image

if {$viewlevel > 0} {
  open_window
  rotate_brain_x 90
  rotate_brain_y 90
  redraw
}

### main skull strip
set i 0
while {$i < $shrinksteps} {

  if {$i == 0} {
    set rgb skullstrip[format "%04d" $i].tiff
    if {$viewlevel == 1} { redraw }
    if {$viewlevel == 2} { save_rgb }  ;# save_rgb=pop,double,redraw,save,single
  }

  set momentumflag 1
  set MRIflag 1
  set flattenflag 0
  shrink 2
  incr i 2

  set momentumflag 0
  set MRIflag 0
  set flattenflag 1
  shrink 2
  incr i 2

  set rgb skullstrip[format "%04d" $i].tiff
  if {$viewlevel == 1} { redraw }
  if {$viewlevel == 2} { save_rgb }

  puts "skullstrip.tcl: ######## step $i of $shrinksteps ########"
}

### smooth final surface
set j [expr $i + $smoothsteps]
while {$i < $j} {
  shrink 1
  incr i
  set rgb skullstrip[format "%04d" $i].tiff
  if {$viewlevel == 1} { redraw }
  if {$viewlevel == 2} { save_rgb }
}

### write out final tri (icos) surface in subject's surfdir
setfile outsurf ~/surf/$outsurfname
if [info exists nosave] {
  puts "stripskull.tcl: nosave setenv'd => stripskull surface not saved"
} else {
  write_geometry
}

### use surface to peel T1, write out peeled images (brain)
peel_brain
setfile outim ~/mri/$outimagedir
if [info exists nosave] {
  puts "stripskull.tcl: nosave setenv'd => brain imageset not saved"
} else {
  write_images
}

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

