#! /usr/bin/tclsh
##############################################################################
# tkmedit script: mri2mpg    [save coronal,horizontal,sagittal tiffs or mpgs]
##############################################################################
### N.B.: caller must init $userok to 0 (uses current surface pose)

### bound to F12 in tkmedit interface window

### defaults
set cormpg_min 15
set cormpg_max 241
set hormpg_min 0
set hormpg_max 220
set sagmpg_min 40
set sagmpg_max 216
set linearflag 0
set "mpg=0,tiffs=1" 0  ;# tifs=2, jpgs=3 (sgitopnm zz.rgb | pnmtojpeg > zz.jpg)

### two ways to override defaults
if [winfo viewable .] {    ;# make popup
  if {!$userok} {
    controls "MRI -> MPGs or RGBs\n\n(to skip plane:\nset limits equal)\n" { \
      cormpg_min cormpg_max sagmpg_min sagmpg_max hormpg_min hormpg_max \
      linearflag "mpg=0,tiffs=1" } \
      "RUN SCRIPT" "set userok 1; source [info script]"
    return
  }
} else {                   ;# batch scripts; re-read env to override defaults
  source $env(CSURF_DIR)/lib/tcl/readenv.tcl
}
puts "mri2mpg.tcl: making movies of mri slices"
prompt

### for command line script (harmless error if gl win open)
open_window

### make tiffs for each plane
if [info exists tiffoutflag] {set tiffoutsave $tiffoutflag; set tiffoutflag 0}
if {$subject != "local"} {
  set subrgbdir $env(SUBJECTS_DIR)/$subject/rgb
  if ![file exists $subrgbdir] {
    exec mkdir $subrgbdir
    if ![file exists $subrgbdir] {
      confirmalert "mkdir $subrgbdir failed"; return
    }
  }
  cd $subrgbdir
}
foreach stem { cor hor sag } {
  set min [set ${stem}mpg_min]
  set max [set ${stem}mpg_max]
  if {$max == $min} { continue }
  if {$stem == "cor"} { set plane 0 }
  if {$stem == "hor"} { set plane 1 }
  if {$stem == "sag"} { set plane 2 }
  set newimc 0; set newic 0; set newjc 0  ;# cursor lower left
  set cursoggb 0   ;# dim cursor
  set rgbslice $min
  while {$rgbslice < $max} {
    gotoslice $rgbslice
    set rgb $stem[format "%03d" $rgbslice].tiff
    raise_window
    set tiffoutflag 1
    save_rgb
    incr rgbslice
  }
}
if [info exists tiffoutflag] { set tiffoutflag $tiffoutsave }

if {"${mpg=0,tiffs=1}" == 0} {
  ### convert rgb's to mpg
  after 200 { set userok $userok }
  confirmalert "making mpegs -- takes half a min"
  foreach stem { cor hor sag } {
    set min [set ${stem}mpg_min]
    set max [set ${stem}mpg_max]
    if {$max == $min} { continue }
    puts "mri2mpg.tcl: making $stem.mpg"
    prompt
    set id [open TmpCshScript w 0644]
    puts $id "tiff2mpg -q 1 $stem\\*.tiff $stem.mpg"
    close $id
    exec tcsh TmpCshScript
  }
  
  ### move into subjects' mpg dir (if not run as local)
  if {$subject != "local"} {
    set submpgdir $env(SUBJECTS_DIR)/$subject/mpg
    if ![file exists $submpgdir] { exec mkdir $submpgdir }
    foreach stem { cor hor sag } {
      if { [file exists $submpgdir] && [file exists $stem.mpg] } {
        exec mv $stem.mpg $submpgdir
      }
    }
  }
  exec rm -f TmpCshScript
  if { [winfo viewable .] && $subject != "local" } {
    confirmalert "structural movies:\
              \n\n    cor.mpg\
                \n    hor.mpg\
                \n    sag.mpg\
              \n\nsaved in:\
              \n\n    $submpgdir\
              \n\nOK starts tiff cleanup"
  }
}

### cleanup
if {"${mpg=0,tiffs=1}" == 1} {
  set subrgbdir $env(SUBJECTS_DIR)/$subject/rgb
  if { [winfo viewable .] && $subject != "local" } {
    confirmalert "tiffs saved in $subrgbdir"
  }
} else {  ;# cleanup tiffs
  foreach rgbfile [glob cor???.tiff hor???.tiff sag???.tiff] {exec rm $rgbfile}
}

if ![winfo viewable .] { exit }

