#! /usr/bin/tclsh
##############################################################################
# tksurfer script: fs-views    [read fieldsign, display on folded/unfolded]
##############################################################################
### wrap entire script so script errors/crashes can go to log
catch {

### session dir autoset to $cwd/.. when cwd=scripts (standalone: set here)
#set isession /usr0/fspace/110329MS/image

### tcl-only defs (set for standalone tclscript, order: cmdline,here,readenv)
#set dir fs              ;# scandir, usu. subdir of "image/" (old: 004/image7)
#set rgbname fs          ;# stem for rgbfiles

### C-parm defs (set for standalone tclscript, order: cmdline,here,readenv)
#set overlayflag 1       ;# overlay data on gray brain
#set surfcolor 1         ;# draw the curvature under data
#set avgflag 1           ;# make half convex/concave
#set complexvalflag 0    ;# one-component data
#set colscale 9          ;# no-op EXTRA_SIGNED
#set fthresh 0.3         ;# val/curv sigmoid zero (neg=>0)
#set fslope 5.0          ;# contast
#set fmid   0.6          ;# set linear region
#set offset 0.30         ;# default lighting offset
#set cvfact 1.30         ;# background light/dark curv gray contrast
#set light2 0.8          ;# bakcompat: more top light (old tksurfer def=0.6)

### default missing tcl-only for standalone, except req'd dir
if ![info exists dir ]    { set dir fs }
if ![info exists rgbname] { set rgbname $dir }
set complexvalflag 0     ;# force correct

### read non-cap setenv vars (or ext w/correct rgbname) to override defaults
source $env(CSURF_DIR)/lib/tcl/readenv.tcl

### read curvature (or sulc)
puts "tksurfer: [file tail $script]: read curvature"
read_binary_curv

### read fieldsign color and mask
setfile fs */$dir/$hemi.fs
setfile fm */$dir/$hemi.fm
puts "tksurfer: [file tail $script]: read fieldsign"
read_fieldsign          ;# written with fs-flat.tcl, sets fieldsignflag
puts "tksurfer: [file tail $script]: read fieldsign mask"
read_fsmask             ;# ditto

### override flag reset from bad setenv colscale
if {$fieldsignflag} { set complexvalflag 0 }

### scale and position brain
puts "tksurfer: [file tail $script]: scale, position brain"
open_window
make_lateral_view       ;# rotate either hemisphere
do_lighting_model

### save requested rgbs
puts "tksurfer: [file tail $script]: save rgb's"
source $env(CSURF_DIR)/lib/tcl/saveviews.tcl

### errors (if any) to log
} ret
if {$ret != ""} { puts "tksurfer: [file tail $script]: ### $ret" }

if ![info exists noexit] { exit }

